// SPDX-License-Identifier: Apache-2.0 OR MIT
// This file is @generated by cfg.sh.
// It is not intended for manual editing.

//! Trait and types for [`Config::cfg`](crate::Config::cfg).

#![cfg_attr(rustfmt, rustfmt::skip)]
#![allow(non_camel_case_types)]

use alloc::{boxed::Box, string::String, vec, vec::Vec};
use core::{fmt, mem, str::FromStr};

pub trait Cfg {
    /// The type returned from [`Config::cfg`](crate::Config::cfg) when no error occurred.
    type Output: Sized;
    /// The name of this cfg.
    const KEY: &'static str;
    /// (For use inside [`Config::cfg`](crate::Config::cfg).)
    type Error: Sized + std::error::Error + Send + Sync + 'static;
    /// (For use inside [`Config::cfg`](crate::Config::cfg).)
    ///
    /// The maximum number of this cfg.
    ///
    /// In all implementation provided by this crate, if `Self::Output` is a
    /// collection type such as `Vec` it is `usize::MAX`, otherwise `1`.
    const MAX: usize;
    /// (For use inside [`Config::cfg`](crate::Config::cfg).)
    ///
    /// The length of `values` is `1..=Self::MAX`.
    fn from_values<I: ExactSizeIterator<Item = V>, V: AsRef<str>>(
        values: I,
    ) -> Result<Self::Output, Self::Error>;
    /// (For use inside [`Config::cfg`](crate::Config::cfg).)
    ///
    /// The value returned if cfg is not found. If `None`, an error is returned in such a case.
    fn default_output() -> Option<Self::Output>;
}

/// `cfg(target_abi == "..")`
/// (Rust 1.78+)
///
/// All non-empty values used in builtin targets in 1.8 (where `rustc --print cfg` was added)
/// to 1.93 are available as variants. To construct other values, use
/// `TargetAbi::from`/`.into()`; to reference them, use `.as_str()` or comparison to `&str`.
#[derive(Clone)]
#[non_exhaustive]
pub enum TargetAbi {
    abi64,
    abiv2,
    abiv2hf,
    eabi,
    eabihf,
    elf,
    elfv1,
    elfv2,
    fortanix,
    ilp32,
    ilp32e,
    llvm,
    macabi,
    sim,
    softfloat,
    spe,
    uwp,
    vec_extabi,
    x32,
    #[doc(hidden)]
    #[deprecated(note = "do not use this variant directly; use as_str or compare with a string instead")]
    __Other(Box<str>),
}
impl TargetAbi {
    #[must_use]
    pub const fn as_str(&self) -> &str {
        match self {
            Self::abi64 => "abi64",
            Self::abiv2 => "abiv2",
            Self::abiv2hf => "abiv2hf",
            Self::eabi => "eabi",
            Self::eabihf => "eabihf",
            Self::elf => "elf",
            Self::elfv1 => "elfv1",
            Self::elfv2 => "elfv2",
            Self::fortanix => "fortanix",
            Self::ilp32 => "ilp32",
            Self::ilp32e => "ilp32e",
            Self::llvm => "llvm",
            Self::macabi => "macabi",
            Self::sim => "sim",
            Self::softfloat => "softfloat",
            Self::spe => "spe",
            Self::uwp => "uwp",
            Self::vec_extabi => "vec-extabi",
            Self::x32 => "x32",
            #[allow(deprecated)]
            Self::__Other(s) => s,
        }
    }
}
impl PartialEq for TargetAbi {
    fn eq(&self, other: &Self) -> bool {
        match (self, other) {
            // Even after new variants are added, to ensure comparisons in old
            // code using __Other still work, compare strings if either is __Other.
            #[allow(deprecated)]
            (Self::__Other(_), _) | (_, Self::__Other(_)) => self.as_str() == other.as_str(),
            (this, other) => mem::discriminant(this) == mem::discriminant(other),
        }
    }
}
impl Eq for TargetAbi {}
impl PartialEq<str> for TargetAbi {
    fn eq(&self, other: &str) -> bool {
        *self.as_str() == *other
    }
}
impl PartialEq<&str> for TargetAbi {
    fn eq(&self, &other: &&str) -> bool {
        *self.as_str() == *other
    }
}
impl PartialEq<TargetAbi> for str {
    fn eq(&self, other: &TargetAbi) -> bool {
        *self == *other.as_str()
    }
}
impl PartialEq<TargetAbi> for &str {
    fn eq(&self, other: &TargetAbi) -> bool {
        **self == *other.as_str()
    }
}
impl PartialEq<String> for TargetAbi {
    fn eq(&self, other: &String) -> bool {
        *self.as_str() == **other
    }
}
impl PartialEq<&String> for TargetAbi {
    fn eq(&self, &other: &&String) -> bool {
        *self.as_str() == **other
    }
}
impl PartialEq<TargetAbi> for String {
    fn eq(&self, other: &TargetAbi) -> bool {
        **self == *other.as_str()
    }
}
impl PartialEq<TargetAbi> for &String {
    fn eq(&self, other: &TargetAbi) -> bool {
        ***self == *other.as_str()
    }
}
impl PartialEq<Box<str>> for TargetAbi {
    fn eq(&self, other: &Box<str>) -> bool {
        *self.as_str() == **other
    }
}
impl PartialEq<&Box<str>> for TargetAbi {
    fn eq(&self, &other: &&Box<str>) -> bool {
        *self.as_str() == **other
    }
}
impl PartialEq<TargetAbi> for Box<str> {
    fn eq(&self, other: &TargetAbi) -> bool {
        **self == *other.as_str()
    }
}
impl PartialEq<TargetAbi> for &Box<str> {
    fn eq(&self, other: &TargetAbi) -> bool {
        ***self == *other.as_str()
    }
}
impl From<&str> for TargetAbi {
    fn from(s: &str) -> Self {
        match Self::from_str(s) {
            Ok(s) => s,
            Err(e) => match e {},
        }
    }
}
impl FromStr for TargetAbi {
    type Err = core::convert::Infallible;
    fn from_str(s: &str) -> Result<Self, Self::Err> {
        match s {
            "abi64" => Ok(Self::abi64),
            "abiv2" => Ok(Self::abiv2),
            "abiv2hf" => Ok(Self::abiv2hf),
            "eabi" => Ok(Self::eabi),
            "eabihf" => Ok(Self::eabihf),
            "elf" => Ok(Self::elf),
            "elfv1" => Ok(Self::elfv1),
            "elfv2" => Ok(Self::elfv2),
            "fortanix" => Ok(Self::fortanix),
            "ilp32" => Ok(Self::ilp32),
            "ilp32e" => Ok(Self::ilp32e),
            "llvm" => Ok(Self::llvm),
            "macabi" => Ok(Self::macabi),
            "sim" => Ok(Self::sim),
            "softfloat" => Ok(Self::softfloat),
            "spe" => Ok(Self::spe),
            "uwp" => Ok(Self::uwp),
            "vec-extabi" => Ok(Self::vec_extabi),
            "x32" => Ok(Self::x32),
            #[allow(deprecated)]
            s => Ok(Self::__Other(s.into())),
        }
    }
}
impl Cfg for TargetAbi {
    type Output = Option<Self>;
    const KEY: &'static str = "target_abi";
    type Error = core::convert::Infallible;
    const MAX: usize = 1;
    fn from_values<I: ExactSizeIterator<Item = V>, V: AsRef<str>>(
        mut values: I,
    ) -> Result<Self::Output, Self::Error> {
        Ok(Some(values.next().unwrap().as_ref().parse()?))
    }
    fn default_output() -> Option<Self::Output> {
        Some(None)
    }
}
impl fmt::Debug for TargetAbi {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        fmt::Debug::fmt(self.as_str(), f)
    }
}
impl fmt::Display for TargetAbi {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        f.write_str(self.as_str())
    }
}

/// `cfg(target_arch == "..")`
///
/// All non-empty values used in builtin targets in 1.8 (where `rustc --print cfg` was added)
/// to 1.93 are available as variants. To construct other values, use
/// `TargetArch::from`/`.into()`; to reference them, use `.as_str()` or comparison to `&str`.
#[derive(Clone)]
#[non_exhaustive]
pub enum TargetArch {
    aarch64,
    amdgpu,
    arm,
    arm64ec,
    asmjs,
    avr,
    bpf,
    csky,
    hexagon,
    le32,
    loongarch32,
    loongarch64,
    m68k,
    mips,
    mips32r6,
    mips64,
    mips64r6,
    msp430,
    nvptx64,
    powerpc,
    powerpc64,
    riscv32,
    riscv64,
    s390x,
    sparc,
    sparc64,
    wasm32,
    wasm64,
    x86,
    x86_64,
    xtensa,
    #[doc(hidden)]
    #[deprecated(note = "do not use this variant directly; use as_str or compare with a string instead")]
    __Other(Box<str>),
}
impl TargetArch {
    #[must_use]
    pub const fn as_str(&self) -> &str {
        match self {
            Self::aarch64 => "aarch64",
            Self::amdgpu => "amdgpu",
            Self::arm => "arm",
            Self::arm64ec => "arm64ec",
            Self::asmjs => "asmjs",
            Self::avr => "avr",
            Self::bpf => "bpf",
            Self::csky => "csky",
            Self::hexagon => "hexagon",
            Self::le32 => "le32",
            Self::loongarch32 => "loongarch32",
            Self::loongarch64 => "loongarch64",
            Self::m68k => "m68k",
            Self::mips => "mips",
            Self::mips32r6 => "mips32r6",
            Self::mips64 => "mips64",
            Self::mips64r6 => "mips64r6",
            Self::msp430 => "msp430",
            Self::nvptx64 => "nvptx64",
            Self::powerpc => "powerpc",
            Self::powerpc64 => "powerpc64",
            Self::riscv32 => "riscv32",
            Self::riscv64 => "riscv64",
            Self::s390x => "s390x",
            Self::sparc => "sparc",
            Self::sparc64 => "sparc64",
            Self::wasm32 => "wasm32",
            Self::wasm64 => "wasm64",
            Self::x86 => "x86",
            Self::x86_64 => "x86_64",
            Self::xtensa => "xtensa",
            #[allow(deprecated)]
            Self::__Other(s) => s,
        }
    }
}
impl PartialEq for TargetArch {
    fn eq(&self, other: &Self) -> bool {
        match (self, other) {
            // Even after new variants are added, to ensure comparisons in old
            // code using __Other still work, compare strings if either is __Other.
            #[allow(deprecated)]
            (Self::__Other(_), _) | (_, Self::__Other(_)) => self.as_str() == other.as_str(),
            (this, other) => mem::discriminant(this) == mem::discriminant(other),
        }
    }
}
impl Eq for TargetArch {}
impl PartialEq<str> for TargetArch {
    fn eq(&self, other: &str) -> bool {
        *self.as_str() == *other
    }
}
impl PartialEq<&str> for TargetArch {
    fn eq(&self, &other: &&str) -> bool {
        *self.as_str() == *other
    }
}
impl PartialEq<TargetArch> for str {
    fn eq(&self, other: &TargetArch) -> bool {
        *self == *other.as_str()
    }
}
impl PartialEq<TargetArch> for &str {
    fn eq(&self, other: &TargetArch) -> bool {
        **self == *other.as_str()
    }
}
impl PartialEq<String> for TargetArch {
    fn eq(&self, other: &String) -> bool {
        *self.as_str() == **other
    }
}
impl PartialEq<&String> for TargetArch {
    fn eq(&self, &other: &&String) -> bool {
        *self.as_str() == **other
    }
}
impl PartialEq<TargetArch> for String {
    fn eq(&self, other: &TargetArch) -> bool {
        **self == *other.as_str()
    }
}
impl PartialEq<TargetArch> for &String {
    fn eq(&self, other: &TargetArch) -> bool {
        ***self == *other.as_str()
    }
}
impl PartialEq<Box<str>> for TargetArch {
    fn eq(&self, other: &Box<str>) -> bool {
        *self.as_str() == **other
    }
}
impl PartialEq<&Box<str>> for TargetArch {
    fn eq(&self, &other: &&Box<str>) -> bool {
        *self.as_str() == **other
    }
}
impl PartialEq<TargetArch> for Box<str> {
    fn eq(&self, other: &TargetArch) -> bool {
        **self == *other.as_str()
    }
}
impl PartialEq<TargetArch> for &Box<str> {
    fn eq(&self, other: &TargetArch) -> bool {
        ***self == *other.as_str()
    }
}
impl From<&str> for TargetArch {
    fn from(s: &str) -> Self {
        match Self::from_str(s) {
            Ok(s) => s,
            Err(e) => match e {},
        }
    }
}
impl FromStr for TargetArch {
    type Err = core::convert::Infallible;
    fn from_str(s: &str) -> Result<Self, Self::Err> {
        match s {
            "aarch64" => Ok(Self::aarch64),
            "amdgpu" => Ok(Self::amdgpu),
            "arm" => Ok(Self::arm),
            "arm64ec" => Ok(Self::arm64ec),
            "asmjs" => Ok(Self::asmjs),
            "avr" => Ok(Self::avr),
            "bpf" => Ok(Self::bpf),
            "csky" => Ok(Self::csky),
            "hexagon" => Ok(Self::hexagon),
            "le32" => Ok(Self::le32),
            "loongarch32" => Ok(Self::loongarch32),
            "loongarch64" => Ok(Self::loongarch64),
            "m68k" => Ok(Self::m68k),
            "mips" => Ok(Self::mips),
            "mips32r6" => Ok(Self::mips32r6),
            "mips64" => Ok(Self::mips64),
            "mips64r6" => Ok(Self::mips64r6),
            "msp430" => Ok(Self::msp430),
            "nvptx64" => Ok(Self::nvptx64),
            "powerpc" => Ok(Self::powerpc),
            "powerpc64" => Ok(Self::powerpc64),
            "riscv32" => Ok(Self::riscv32),
            "riscv64" => Ok(Self::riscv64),
            "s390x" => Ok(Self::s390x),
            "sparc" => Ok(Self::sparc),
            "sparc64" => Ok(Self::sparc64),
            "wasm32" => Ok(Self::wasm32),
            "wasm64" => Ok(Self::wasm64),
            "x86" => Ok(Self::x86),
            "x86_64" => Ok(Self::x86_64),
            "xtensa" => Ok(Self::xtensa),
            #[allow(deprecated)]
            s => Ok(Self::__Other(s.into())),
        }
    }
}
impl Cfg for TargetArch {
    type Output = Self;
    const KEY: &'static str = "target_arch";
    type Error = core::convert::Infallible;
    const MAX: usize = 1;
    fn from_values<I: ExactSizeIterator<Item = V>, V: AsRef<str>>(
        mut values: I,
    ) -> Result<Self::Output, Self::Error> {
        values.next().unwrap().as_ref().parse()
    }
    fn default_output() -> Option<Self::Output> {
        None
    }
}
impl fmt::Debug for TargetArch {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        fmt::Debug::fmt(self.as_str(), f)
    }
}
impl fmt::Display for TargetArch {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        f.write_str(self.as_str())
    }
}

/// `cfg(target_endian == "..")`
///
/// All non-empty values used in builtin targets in 1.8 (where `rustc --print cfg` was added)
/// to 1.93 are available as variants. To construct other values, use
/// `TargetEndian::from`/`.into()`; to reference them, use `.as_str()` or comparison to `&str`.
#[derive(Clone, PartialEq, Eq)]
#[allow(clippy::exhaustive_enums)]
pub enum TargetEndian {
    big,
    little,
}
impl TargetEndian {
    #[must_use]
    pub const fn as_str(&self) -> &str {
        match self {
            Self::big => "big",
            Self::little => "little",
        }
    }
}
impl PartialEq<str> for TargetEndian {
    fn eq(&self, other: &str) -> bool {
        *self.as_str() == *other
    }
}
impl PartialEq<&str> for TargetEndian {
    fn eq(&self, &other: &&str) -> bool {
        *self.as_str() == *other
    }
}
impl PartialEq<TargetEndian> for str {
    fn eq(&self, other: &TargetEndian) -> bool {
        *self == *other.as_str()
    }
}
impl PartialEq<TargetEndian> for &str {
    fn eq(&self, other: &TargetEndian) -> bool {
        **self == *other.as_str()
    }
}
impl PartialEq<String> for TargetEndian {
    fn eq(&self, other: &String) -> bool {
        *self.as_str() == **other
    }
}
impl PartialEq<&String> for TargetEndian {
    fn eq(&self, &other: &&String) -> bool {
        *self.as_str() == **other
    }
}
impl PartialEq<TargetEndian> for String {
    fn eq(&self, other: &TargetEndian) -> bool {
        **self == *other.as_str()
    }
}
impl PartialEq<TargetEndian> for &String {
    fn eq(&self, other: &TargetEndian) -> bool {
        ***self == *other.as_str()
    }
}
impl PartialEq<Box<str>> for TargetEndian {
    fn eq(&self, other: &Box<str>) -> bool {
        *self.as_str() == **other
    }
}
impl PartialEq<&Box<str>> for TargetEndian {
    fn eq(&self, &other: &&Box<str>) -> bool {
        *self.as_str() == **other
    }
}
impl PartialEq<TargetEndian> for Box<str> {
    fn eq(&self, other: &TargetEndian) -> bool {
        **self == *other.as_str()
    }
}
impl PartialEq<TargetEndian> for &Box<str> {
    fn eq(&self, other: &TargetEndian) -> bool {
        ***self == *other.as_str()
    }
}
impl FromStr for TargetEndian {
    type Err = crate::Error;
    fn from_str(s: &str) -> Result<Self, Self::Err> {
        match s {
            "big" => Ok(Self::big),
            "little" => Ok(Self::little),
            other => bail!("must be one of big, little, but found `{other}`"),
        }
    }
}
impl Cfg for TargetEndian {
    type Output = Self;
    const KEY: &'static str = "target_endian";
    type Error = crate::Error;
    const MAX: usize = 1;
    fn from_values<I: ExactSizeIterator<Item = V>, V: AsRef<str>>(
        mut values: I,
    ) -> Result<Self::Output, Self::Error> {
        values.next().unwrap().as_ref().parse()
    }
    fn default_output() -> Option<Self::Output> {
        None
    }
}
impl fmt::Debug for TargetEndian {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        fmt::Debug::fmt(self.as_str(), f)
    }
}
impl fmt::Display for TargetEndian {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        f.write_str(self.as_str())
    }
}

/// `cfg(target_env == "..")`
///
/// All non-empty values used in builtin targets in 1.8 (where `rustc --print cfg` was added)
/// to 1.93 are available as variants. To construct other values, use
/// `TargetEnv::from`/`.into()`; to reference them, use `.as_str()` or comparison to `&str`.
#[derive(Clone)]
#[non_exhaustive]
pub enum TargetEnv {
    eabihf,
    gnu,
    gnueabi,
    gnueabihf,
    macabi,
    mlibc,
    msvc,
    musl,
    newlib,
    nto70,
    nto71,
    nto71_iosock,
    nto80,
    ohos,
    p1,
    p2,
    p3,
    psx,
    relibc,
    sgx,
    sim,
    uclibc,
    v5,
    wasi,
    #[doc(hidden)]
    #[deprecated(note = "do not use this variant directly; use as_str or compare with a string instead")]
    __Other(Box<str>),
}
impl TargetEnv {
    #[must_use]
    pub const fn as_str(&self) -> &str {
        match self {
            Self::eabihf => "eabihf",
            Self::gnu => "gnu",
            Self::gnueabi => "gnueabi",
            Self::gnueabihf => "gnueabihf",
            Self::macabi => "macabi",
            Self::mlibc => "mlibc",
            Self::msvc => "msvc",
            Self::musl => "musl",
            Self::newlib => "newlib",
            Self::nto70 => "nto70",
            Self::nto71 => "nto71",
            Self::nto71_iosock => "nto71_iosock",
            Self::nto80 => "nto80",
            Self::ohos => "ohos",
            Self::p1 => "p1",
            Self::p2 => "p2",
            Self::p3 => "p3",
            Self::psx => "psx",
            Self::relibc => "relibc",
            Self::sgx => "sgx",
            Self::sim => "sim",
            Self::uclibc => "uclibc",
            Self::v5 => "v5",
            Self::wasi => "wasi",
            #[allow(deprecated)]
            Self::__Other(s) => s,
        }
    }
}
impl PartialEq for TargetEnv {
    fn eq(&self, other: &Self) -> bool {
        match (self, other) {
            // Even after new variants are added, to ensure comparisons in old
            // code using __Other still work, compare strings if either is __Other.
            #[allow(deprecated)]
            (Self::__Other(_), _) | (_, Self::__Other(_)) => self.as_str() == other.as_str(),
            (this, other) => mem::discriminant(this) == mem::discriminant(other),
        }
    }
}
impl Eq for TargetEnv {}
impl PartialEq<str> for TargetEnv {
    fn eq(&self, other: &str) -> bool {
        *self.as_str() == *other
    }
}
impl PartialEq<&str> for TargetEnv {
    fn eq(&self, &other: &&str) -> bool {
        *self.as_str() == *other
    }
}
impl PartialEq<TargetEnv> for str {
    fn eq(&self, other: &TargetEnv) -> bool {
        *self == *other.as_str()
    }
}
impl PartialEq<TargetEnv> for &str {
    fn eq(&self, other: &TargetEnv) -> bool {
        **self == *other.as_str()
    }
}
impl PartialEq<String> for TargetEnv {
    fn eq(&self, other: &String) -> bool {
        *self.as_str() == **other
    }
}
impl PartialEq<&String> for TargetEnv {
    fn eq(&self, &other: &&String) -> bool {
        *self.as_str() == **other
    }
}
impl PartialEq<TargetEnv> for String {
    fn eq(&self, other: &TargetEnv) -> bool {
        **self == *other.as_str()
    }
}
impl PartialEq<TargetEnv> for &String {
    fn eq(&self, other: &TargetEnv) -> bool {
        ***self == *other.as_str()
    }
}
impl PartialEq<Box<str>> for TargetEnv {
    fn eq(&self, other: &Box<str>) -> bool {
        *self.as_str() == **other
    }
}
impl PartialEq<&Box<str>> for TargetEnv {
    fn eq(&self, &other: &&Box<str>) -> bool {
        *self.as_str() == **other
    }
}
impl PartialEq<TargetEnv> for Box<str> {
    fn eq(&self, other: &TargetEnv) -> bool {
        **self == *other.as_str()
    }
}
impl PartialEq<TargetEnv> for &Box<str> {
    fn eq(&self, other: &TargetEnv) -> bool {
        ***self == *other.as_str()
    }
}
impl From<&str> for TargetEnv {
    fn from(s: &str) -> Self {
        match Self::from_str(s) {
            Ok(s) => s,
            Err(e) => match e {},
        }
    }
}
impl FromStr for TargetEnv {
    type Err = core::convert::Infallible;
    fn from_str(s: &str) -> Result<Self, Self::Err> {
        match s {
            "eabihf" => Ok(Self::eabihf),
            "gnu" => Ok(Self::gnu),
            "gnueabi" => Ok(Self::gnueabi),
            "gnueabihf" => Ok(Self::gnueabihf),
            "macabi" => Ok(Self::macabi),
            "mlibc" => Ok(Self::mlibc),
            "msvc" => Ok(Self::msvc),
            "musl" => Ok(Self::musl),
            "newlib" => Ok(Self::newlib),
            "nto70" => Ok(Self::nto70),
            "nto71" => Ok(Self::nto71),
            "nto71_iosock" => Ok(Self::nto71_iosock),
            "nto80" => Ok(Self::nto80),
            "ohos" => Ok(Self::ohos),
            "p1" => Ok(Self::p1),
            "p2" => Ok(Self::p2),
            "p3" => Ok(Self::p3),
            "psx" => Ok(Self::psx),
            "relibc" => Ok(Self::relibc),
            "sgx" => Ok(Self::sgx),
            "sim" => Ok(Self::sim),
            "uclibc" => Ok(Self::uclibc),
            "v5" => Ok(Self::v5),
            "wasi" => Ok(Self::wasi),
            #[allow(deprecated)]
            s => Ok(Self::__Other(s.into())),
        }
    }
}
impl Cfg for TargetEnv {
    type Output = Option<Self>;
    const KEY: &'static str = "target_env";
    type Error = core::convert::Infallible;
    const MAX: usize = 1;
    fn from_values<I: ExactSizeIterator<Item = V>, V: AsRef<str>>(
        mut values: I,
    ) -> Result<Self::Output, Self::Error> {
        Ok(Some(values.next().unwrap().as_ref().parse()?))
    }
    fn default_output() -> Option<Self::Output> {
        Some(None)
    }
}
impl fmt::Debug for TargetEnv {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        fmt::Debug::fmt(self.as_str(), f)
    }
}
impl fmt::Display for TargetEnv {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        f.write_str(self.as_str())
    }
}

/// `cfg(target_family == "..")`
///
/// All non-empty values used in builtin targets in 1.8 (where `rustc --print cfg` was added)
/// to 1.93 are available as variants. To construct other values, use
/// `TargetFamily::from`/`.into()`; to reference them, use `.as_str()` or comparison to `&str`.
#[derive(Clone)]
#[non_exhaustive]
pub enum TargetFamily {
    unix,
    wasm,
    windows,
    #[doc(hidden)]
    #[deprecated(note = "do not use this variant directly; use as_str or compare with a string instead")]
    __Other(Box<str>),
}
impl TargetFamily {
    #[must_use]
    pub const fn as_str(&self) -> &str {
        match self {
            Self::unix => "unix",
            Self::wasm => "wasm",
            Self::windows => "windows",
            #[allow(deprecated)]
            Self::__Other(s) => s,
        }
    }
}
impl PartialEq for TargetFamily {
    fn eq(&self, other: &Self) -> bool {
        match (self, other) {
            // Even after new variants are added, to ensure comparisons in old
            // code using __Other still work, compare strings if either is __Other.
            #[allow(deprecated)]
            (Self::__Other(_), _) | (_, Self::__Other(_)) => self.as_str() == other.as_str(),
            (this, other) => mem::discriminant(this) == mem::discriminant(other),
        }
    }
}
impl Eq for TargetFamily {}
impl PartialEq<str> for TargetFamily {
    fn eq(&self, other: &str) -> bool {
        *self.as_str() == *other
    }
}
impl PartialEq<&str> for TargetFamily {
    fn eq(&self, &other: &&str) -> bool {
        *self.as_str() == *other
    }
}
impl PartialEq<TargetFamily> for str {
    fn eq(&self, other: &TargetFamily) -> bool {
        *self == *other.as_str()
    }
}
impl PartialEq<TargetFamily> for &str {
    fn eq(&self, other: &TargetFamily) -> bool {
        **self == *other.as_str()
    }
}
impl PartialEq<String> for TargetFamily {
    fn eq(&self, other: &String) -> bool {
        *self.as_str() == **other
    }
}
impl PartialEq<&String> for TargetFamily {
    fn eq(&self, &other: &&String) -> bool {
        *self.as_str() == **other
    }
}
impl PartialEq<TargetFamily> for String {
    fn eq(&self, other: &TargetFamily) -> bool {
        **self == *other.as_str()
    }
}
impl PartialEq<TargetFamily> for &String {
    fn eq(&self, other: &TargetFamily) -> bool {
        ***self == *other.as_str()
    }
}
impl PartialEq<Box<str>> for TargetFamily {
    fn eq(&self, other: &Box<str>) -> bool {
        *self.as_str() == **other
    }
}
impl PartialEq<&Box<str>> for TargetFamily {
    fn eq(&self, &other: &&Box<str>) -> bool {
        *self.as_str() == **other
    }
}
impl PartialEq<TargetFamily> for Box<str> {
    fn eq(&self, other: &TargetFamily) -> bool {
        **self == *other.as_str()
    }
}
impl PartialEq<TargetFamily> for &Box<str> {
    fn eq(&self, other: &TargetFamily) -> bool {
        ***self == *other.as_str()
    }
}
impl From<&str> for TargetFamily {
    fn from(s: &str) -> Self {
        match Self::from_str(s) {
            Ok(s) => s,
            Err(e) => match e {},
        }
    }
}
impl FromStr for TargetFamily {
    type Err = core::convert::Infallible;
    fn from_str(s: &str) -> Result<Self, Self::Err> {
        match s {
            "unix" => Ok(Self::unix),
            "wasm" => Ok(Self::wasm),
            "windows" => Ok(Self::windows),
            #[allow(deprecated)]
            s => Ok(Self::__Other(s.into())),
        }
    }
}
impl Cfg for TargetFamily {
    type Output = Vec<Self>;
    const KEY: &'static str = "target_family";
    type Error = core::convert::Infallible;
    const MAX: usize = usize::MAX;
    fn from_values<I: ExactSizeIterator<Item = V>, V: AsRef<str>>(
        values: I,
    ) -> Result<Self::Output, Self::Error> {
        let mut res = Vec::with_capacity(values.len());
        for value in values {
            res.push(value.as_ref().parse()?);
        }
        Ok(res)
    }
    fn default_output() -> Option<Self::Output> {
        Some(vec![])
    }
}
impl fmt::Debug for TargetFamily {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        fmt::Debug::fmt(self.as_str(), f)
    }
}
impl fmt::Display for TargetFamily {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        f.write_str(self.as_str())
    }
}

/// `cfg(target_has_atomic == "..")`
/// (Rust 1.60+)
///
/// All values used in builtin targets in 1.8 (where `rustc --print cfg` was added)
/// to 1.93 are constructable without allocation. To construct values, use
/// `TargetHasAtomic::from`/`.into()`; to reference them, use `.as_str()` or comparison to `&str`.
#[derive(Clone)]
pub struct TargetHasAtomic(TargetHasAtomicRepr);
#[derive(Clone)]
enum TargetHasAtomicRepr {
    _128,
    _16,
    _32,
    _64,
    _8,
    ptr,
    __Other(Box<str>),
}
impl TargetHasAtomic {
    #[must_use]
    pub const fn as_str(&self) -> &str {
        match &self.0 {
            TargetHasAtomicRepr::_128 => "128",
            TargetHasAtomicRepr::_16 => "16",
            TargetHasAtomicRepr::_32 => "32",
            TargetHasAtomicRepr::_64 => "64",
            TargetHasAtomicRepr::_8 => "8",
            TargetHasAtomicRepr::ptr => "ptr",
            TargetHasAtomicRepr::__Other(s) => s,
        }
    }
}
impl PartialEq for TargetHasAtomic {
    fn eq(&self, other: &Self) -> bool {
        match (&self.0, &other.0) {
            // Even after new variants are added, to ensure comparisons in old
            // code using __Other still work, compare strings if either is __Other.
            (TargetHasAtomicRepr::__Other(_), _) | (_, TargetHasAtomicRepr::__Other(_)) => self.as_str() == other.as_str(),
            (this, other) => mem::discriminant(this) == mem::discriminant(other),
        }
    }
}
impl Eq for TargetHasAtomic {}
impl PartialEq<str> for TargetHasAtomic {
    fn eq(&self, other: &str) -> bool {
        *self.as_str() == *other
    }
}
impl PartialEq<&str> for TargetHasAtomic {
    fn eq(&self, &other: &&str) -> bool {
        *self.as_str() == *other
    }
}
impl PartialEq<TargetHasAtomic> for str {
    fn eq(&self, other: &TargetHasAtomic) -> bool {
        *self == *other.as_str()
    }
}
impl PartialEq<TargetHasAtomic> for &str {
    fn eq(&self, other: &TargetHasAtomic) -> bool {
        **self == *other.as_str()
    }
}
impl PartialEq<String> for TargetHasAtomic {
    fn eq(&self, other: &String) -> bool {
        *self.as_str() == **other
    }
}
impl PartialEq<&String> for TargetHasAtomic {
    fn eq(&self, &other: &&String) -> bool {
        *self.as_str() == **other
    }
}
impl PartialEq<TargetHasAtomic> for String {
    fn eq(&self, other: &TargetHasAtomic) -> bool {
        **self == *other.as_str()
    }
}
impl PartialEq<TargetHasAtomic> for &String {
    fn eq(&self, other: &TargetHasAtomic) -> bool {
        ***self == *other.as_str()
    }
}
impl PartialEq<Box<str>> for TargetHasAtomic {
    fn eq(&self, other: &Box<str>) -> bool {
        *self.as_str() == **other
    }
}
impl PartialEq<&Box<str>> for TargetHasAtomic {
    fn eq(&self, &other: &&Box<str>) -> bool {
        *self.as_str() == **other
    }
}
impl PartialEq<TargetHasAtomic> for Box<str> {
    fn eq(&self, other: &TargetHasAtomic) -> bool {
        **self == *other.as_str()
    }
}
impl PartialEq<TargetHasAtomic> for &Box<str> {
    fn eq(&self, other: &TargetHasAtomic) -> bool {
        ***self == *other.as_str()
    }
}
impl PartialEq<u16> for TargetHasAtomic {
    fn eq(&self, other: &u16) -> bool {
        match &self.0 {
            TargetHasAtomicRepr::_128 => 128 == *other,
            TargetHasAtomicRepr::_16 => 16 == *other,
            TargetHasAtomicRepr::_32 => 32 == *other,
            TargetHasAtomicRepr::_64 => 64 == *other,
            TargetHasAtomicRepr::_8 => 8 == *other,
            TargetHasAtomicRepr::ptr => false,
            TargetHasAtomicRepr::__Other(this) => this.parse().ok() == Some(*other),
        }
    }
}
impl PartialEq<u16> for &TargetHasAtomic {
    fn eq(&self, other: &u16) -> bool {
        *self == other
    }
}
impl PartialEq<TargetHasAtomic> for u16 {
    fn eq(&self, other: &TargetHasAtomic) -> bool {
        other == self
    }
}
impl PartialEq<&TargetHasAtomic> for u16 {
    fn eq(&self, &other: &&TargetHasAtomic) -> bool {
        other == self
    }
}
impl PartialEq<i32> for TargetHasAtomic {
    fn eq(&self, other: &i32) -> bool {
        match &self.0 {
            TargetHasAtomicRepr::_128 => 128 == *other,
            TargetHasAtomicRepr::_16 => 16 == *other,
            TargetHasAtomicRepr::_32 => 32 == *other,
            TargetHasAtomicRepr::_64 => 64 == *other,
            TargetHasAtomicRepr::_8 => 8 == *other,
            TargetHasAtomicRepr::ptr => false,
            TargetHasAtomicRepr::__Other(this) => this.parse().ok() == Some(*other),
        }
    }
}
impl PartialEq<i32> for &TargetHasAtomic {
    fn eq(&self, other: &i32) -> bool {
        *self == other
    }
}
impl PartialEq<TargetHasAtomic> for i32 {
    fn eq(&self, other: &TargetHasAtomic) -> bool {
        other == self
    }
}
impl PartialEq<&TargetHasAtomic> for i32 {
    fn eq(&self, &other: &&TargetHasAtomic) -> bool {
        other == self
    }
}
impl PartialEq<u32> for TargetHasAtomic {
    fn eq(&self, other: &u32) -> bool {
        match &self.0 {
            TargetHasAtomicRepr::_128 => 128 == *other,
            TargetHasAtomicRepr::_16 => 16 == *other,
            TargetHasAtomicRepr::_32 => 32 == *other,
            TargetHasAtomicRepr::_64 => 64 == *other,
            TargetHasAtomicRepr::_8 => 8 == *other,
            TargetHasAtomicRepr::ptr => false,
            TargetHasAtomicRepr::__Other(this) => this.parse().ok() == Some(*other),
        }
    }
}
impl PartialEq<u32> for &TargetHasAtomic {
    fn eq(&self, other: &u32) -> bool {
        *self == other
    }
}
impl PartialEq<TargetHasAtomic> for u32 {
    fn eq(&self, other: &TargetHasAtomic) -> bool {
        other == self
    }
}
impl PartialEq<&TargetHasAtomic> for u32 {
    fn eq(&self, &other: &&TargetHasAtomic) -> bool {
        other == self
    }
}
impl PartialEq<u64> for TargetHasAtomic {
    fn eq(&self, other: &u64) -> bool {
        match &self.0 {
            TargetHasAtomicRepr::_128 => 128 == *other,
            TargetHasAtomicRepr::_16 => 16 == *other,
            TargetHasAtomicRepr::_32 => 32 == *other,
            TargetHasAtomicRepr::_64 => 64 == *other,
            TargetHasAtomicRepr::_8 => 8 == *other,
            TargetHasAtomicRepr::ptr => false,
            TargetHasAtomicRepr::__Other(this) => this.parse().ok() == Some(*other),
        }
    }
}
impl PartialEq<u64> for &TargetHasAtomic {
    fn eq(&self, other: &u64) -> bool {
        *self == other
    }
}
impl PartialEq<TargetHasAtomic> for u64 {
    fn eq(&self, other: &TargetHasAtomic) -> bool {
        other == self
    }
}
impl PartialEq<&TargetHasAtomic> for u64 {
    fn eq(&self, &other: &&TargetHasAtomic) -> bool {
        other == self
    }
}
impl FromStr for TargetHasAtomic {
    type Err = crate::Error;
    fn from_str(s: &str) -> Result<Self, Self::Err> {
        match s {
            "128" => Ok(Self(TargetHasAtomicRepr::_128)),
            "16" => Ok(Self(TargetHasAtomicRepr::_16)),
            "32" => Ok(Self(TargetHasAtomicRepr::_32)),
            "64" => Ok(Self(TargetHasAtomicRepr::_64)),
            "8" => Ok(Self(TargetHasAtomicRepr::_8)),
            "ptr" => Ok(Self(TargetHasAtomicRepr::ptr)),
            s => Ok(Self(TargetHasAtomicRepr::__Other(s.into()))),
        }
    }
}
impl Cfg for TargetHasAtomic {
    type Output = Vec<Self>;
    const KEY: &'static str = "target_has_atomic";
    type Error = crate::Error;
    const MAX: usize = usize::MAX;
    fn from_values<I: ExactSizeIterator<Item = V>, V: AsRef<str>>(
        values: I,
    ) -> Result<Self::Output, Self::Error> {
        let mut res = Vec::with_capacity(values.len());
        for value in values {
            res.push(value.as_ref().parse()?);
        }
        Ok(res)
    }
    fn default_output() -> Option<Self::Output> {
        Some(vec![])
    }
}
impl fmt::Debug for TargetHasAtomic {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        fmt::Debug::fmt(self.as_str(), f)
    }
}
impl fmt::Display for TargetHasAtomic {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        f.write_str(self.as_str())
    }
}

/// `cfg(target_os == "..")`
///
/// All non-empty values used in builtin targets in 1.8 (where `rustc --print cfg` was added)
/// to 1.93 are available as variants. To construct other values, use
/// `TargetOs::from`/`.into()`; to reference them, use `.as_str()` or comparison to `&str`.
#[derive(Clone)]
#[non_exhaustive]
pub enum TargetOs {
    aix,
    amdhsa,
    android,
    bitrig,
    cloudabi,
    cuda,
    cygwin,
    dragonfly,
    emscripten,
    espidf,
    freebsd,
    fuchsia,
    haiku,
    helenos,
    hermit,
    horizon,
    hurd,
    illumos,
    ios,
    l4re,
    linux,
    lynxos178,
    macos,
    managarm,
    motor,
    nacl,
    netbsd,
    none,
    nto,
    nuttx,
    openbsd,
    psp,
    psx,
    qurt,
    redox,
    rtems,
    solaris,
    solid_asp3,
    teeos,
    trusty,
    tvos,
    uefi,
    unknown,
    vexos,
    visionos,
    vita,
    vxworks,
    wasi,
    watchos,
    windows,
    xous,
    zkvm,
    #[doc(hidden)]
    #[deprecated(note = "do not use this variant directly; use as_str or compare with a string instead")]
    __Other(Box<str>),
}
impl TargetOs {
    #[must_use]
    pub const fn as_str(&self) -> &str {
        match self {
            Self::aix => "aix",
            Self::amdhsa => "amdhsa",
            Self::android => "android",
            Self::bitrig => "bitrig",
            Self::cloudabi => "cloudabi",
            Self::cuda => "cuda",
            Self::cygwin => "cygwin",
            Self::dragonfly => "dragonfly",
            Self::emscripten => "emscripten",
            Self::espidf => "espidf",
            Self::freebsd => "freebsd",
            Self::fuchsia => "fuchsia",
            Self::haiku => "haiku",
            Self::helenos => "helenos",
            Self::hermit => "hermit",
            Self::horizon => "horizon",
            Self::hurd => "hurd",
            Self::illumos => "illumos",
            Self::ios => "ios",
            Self::l4re => "l4re",
            Self::linux => "linux",
            Self::lynxos178 => "lynxos178",
            Self::macos => "macos",
            Self::managarm => "managarm",
            Self::motor => "motor",
            Self::nacl => "nacl",
            Self::netbsd => "netbsd",
            Self::none => "none",
            Self::nto => "nto",
            Self::nuttx => "nuttx",
            Self::openbsd => "openbsd",
            Self::psp => "psp",
            Self::psx => "psx",
            Self::qurt => "qurt",
            Self::redox => "redox",
            Self::rtems => "rtems",
            Self::solaris => "solaris",
            Self::solid_asp3 => "solid_asp3",
            Self::teeos => "teeos",
            Self::trusty => "trusty",
            Self::tvos => "tvos",
            Self::uefi => "uefi",
            Self::unknown => "unknown",
            Self::vexos => "vexos",
            Self::visionos => "visionos",
            Self::vita => "vita",
            Self::vxworks => "vxworks",
            Self::wasi => "wasi",
            Self::watchos => "watchos",
            Self::windows => "windows",
            Self::xous => "xous",
            Self::zkvm => "zkvm",
            #[allow(deprecated)]
            Self::__Other(s) => s,
        }
    }
}
impl PartialEq for TargetOs {
    fn eq(&self, other: &Self) -> bool {
        match (self, other) {
            // Even after new variants are added, to ensure comparisons in old
            // code using __Other still work, compare strings if either is __Other.
            #[allow(deprecated)]
            (Self::__Other(_), _) | (_, Self::__Other(_)) => self.as_str() == other.as_str(),
            (this, other) => mem::discriminant(this) == mem::discriminant(other),
        }
    }
}
impl Eq for TargetOs {}
impl PartialEq<str> for TargetOs {
    fn eq(&self, other: &str) -> bool {
        *self.as_str() == *other
    }
}
impl PartialEq<&str> for TargetOs {
    fn eq(&self, &other: &&str) -> bool {
        *self.as_str() == *other
    }
}
impl PartialEq<TargetOs> for str {
    fn eq(&self, other: &TargetOs) -> bool {
        *self == *other.as_str()
    }
}
impl PartialEq<TargetOs> for &str {
    fn eq(&self, other: &TargetOs) -> bool {
        **self == *other.as_str()
    }
}
impl PartialEq<String> for TargetOs {
    fn eq(&self, other: &String) -> bool {
        *self.as_str() == **other
    }
}
impl PartialEq<&String> for TargetOs {
    fn eq(&self, &other: &&String) -> bool {
        *self.as_str() == **other
    }
}
impl PartialEq<TargetOs> for String {
    fn eq(&self, other: &TargetOs) -> bool {
        **self == *other.as_str()
    }
}
impl PartialEq<TargetOs> for &String {
    fn eq(&self, other: &TargetOs) -> bool {
        ***self == *other.as_str()
    }
}
impl PartialEq<Box<str>> for TargetOs {
    fn eq(&self, other: &Box<str>) -> bool {
        *self.as_str() == **other
    }
}
impl PartialEq<&Box<str>> for TargetOs {
    fn eq(&self, &other: &&Box<str>) -> bool {
        *self.as_str() == **other
    }
}
impl PartialEq<TargetOs> for Box<str> {
    fn eq(&self, other: &TargetOs) -> bool {
        **self == *other.as_str()
    }
}
impl PartialEq<TargetOs> for &Box<str> {
    fn eq(&self, other: &TargetOs) -> bool {
        ***self == *other.as_str()
    }
}
impl From<&str> for TargetOs {
    fn from(s: &str) -> Self {
        match Self::from_str(s) {
            Ok(s) => s,
            Err(e) => match e {},
        }
    }
}
impl FromStr for TargetOs {
    type Err = core::convert::Infallible;
    fn from_str(s: &str) -> Result<Self, Self::Err> {
        match s {
            "aix" => Ok(Self::aix),
            "amdhsa" => Ok(Self::amdhsa),
            "android" => Ok(Self::android),
            "bitrig" => Ok(Self::bitrig),
            "cloudabi" => Ok(Self::cloudabi),
            "cuda" => Ok(Self::cuda),
            "cygwin" => Ok(Self::cygwin),
            "dragonfly" => Ok(Self::dragonfly),
            "emscripten" => Ok(Self::emscripten),
            "espidf" => Ok(Self::espidf),
            "freebsd" => Ok(Self::freebsd),
            "fuchsia" => Ok(Self::fuchsia),
            "haiku" => Ok(Self::haiku),
            "helenos" => Ok(Self::helenos),
            "hermit" => Ok(Self::hermit),
            "horizon" => Ok(Self::horizon),
            "hurd" => Ok(Self::hurd),
            "illumos" => Ok(Self::illumos),
            "ios" => Ok(Self::ios),
            "l4re" => Ok(Self::l4re),
            "linux" => Ok(Self::linux),
            "lynxos178" => Ok(Self::lynxos178),
            "macos" => Ok(Self::macos),
            "managarm" => Ok(Self::managarm),
            "motor" => Ok(Self::motor),
            "nacl" => Ok(Self::nacl),
            "netbsd" => Ok(Self::netbsd),
            "none" => Ok(Self::none),
            "nto" => Ok(Self::nto),
            "nuttx" => Ok(Self::nuttx),
            "openbsd" => Ok(Self::openbsd),
            "psp" => Ok(Self::psp),
            "psx" => Ok(Self::psx),
            "qurt" => Ok(Self::qurt),
            "redox" => Ok(Self::redox),
            "rtems" => Ok(Self::rtems),
            "solaris" => Ok(Self::solaris),
            "solid_asp3" => Ok(Self::solid_asp3),
            "teeos" => Ok(Self::teeos),
            "trusty" => Ok(Self::trusty),
            "tvos" => Ok(Self::tvos),
            "uefi" => Ok(Self::uefi),
            "unknown" => Ok(Self::unknown),
            "vexos" => Ok(Self::vexos),
            "visionos" => Ok(Self::visionos),
            "vita" => Ok(Self::vita),
            "vxworks" => Ok(Self::vxworks),
            "wasi" => Ok(Self::wasi),
            "watchos" => Ok(Self::watchos),
            "windows" => Ok(Self::windows),
            "xous" => Ok(Self::xous),
            "zkvm" => Ok(Self::zkvm),
            #[allow(deprecated)]
            s => Ok(Self::__Other(s.into())),
        }
    }
}
impl Cfg for TargetOs {
    type Output = Self;
    const KEY: &'static str = "target_os";
    type Error = core::convert::Infallible;
    const MAX: usize = 1;
    fn from_values<I: ExactSizeIterator<Item = V>, V: AsRef<str>>(
        mut values: I,
    ) -> Result<Self::Output, Self::Error> {
        values.next().unwrap().as_ref().parse()
    }
    fn default_output() -> Option<Self::Output> {
        None
    }
}
impl fmt::Debug for TargetOs {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        fmt::Debug::fmt(self.as_str(), f)
    }
}
impl fmt::Display for TargetOs {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        f.write_str(self.as_str())
    }
}

/// `cfg(target_pointer_width == "..")`
///
/// All values used in builtin targets in 1.8 (where `rustc --print cfg` was added)
/// to 1.93 are constructable without allocation. To construct values, use
/// `TargetPointerWidth::from`/`.into()`; to reference them, use `.as_str()` or comparison to `&str`.
#[derive(Clone)]
pub struct TargetPointerWidth(TargetPointerWidthRepr);
#[derive(Clone)]
enum TargetPointerWidthRepr {
    _16,
    _32,
    _64,
    __Other(Box<str>),
}
impl TargetPointerWidth {
    #[must_use]
    pub const fn as_str(&self) -> &str {
        match &self.0 {
            TargetPointerWidthRepr::_16 => "16",
            TargetPointerWidthRepr::_32 => "32",
            TargetPointerWidthRepr::_64 => "64",
            TargetPointerWidthRepr::__Other(s) => s,
        }
    }
}
impl PartialEq for TargetPointerWidth {
    fn eq(&self, other: &Self) -> bool {
        match (&self.0, &other.0) {
            // Even after new variants are added, to ensure comparisons in old
            // code using __Other still work, compare strings if either is __Other.
            (TargetPointerWidthRepr::__Other(_), _) | (_, TargetPointerWidthRepr::__Other(_)) => self.as_str() == other.as_str(),
            (this, other) => mem::discriminant(this) == mem::discriminant(other),
        }
    }
}
impl Eq for TargetPointerWidth {}
impl PartialEq<str> for TargetPointerWidth {
    fn eq(&self, other: &str) -> bool {
        *self.as_str() == *other
    }
}
impl PartialEq<&str> for TargetPointerWidth {
    fn eq(&self, &other: &&str) -> bool {
        *self.as_str() == *other
    }
}
impl PartialEq<TargetPointerWidth> for str {
    fn eq(&self, other: &TargetPointerWidth) -> bool {
        *self == *other.as_str()
    }
}
impl PartialEq<TargetPointerWidth> for &str {
    fn eq(&self, other: &TargetPointerWidth) -> bool {
        **self == *other.as_str()
    }
}
impl PartialEq<String> for TargetPointerWidth {
    fn eq(&self, other: &String) -> bool {
        *self.as_str() == **other
    }
}
impl PartialEq<&String> for TargetPointerWidth {
    fn eq(&self, &other: &&String) -> bool {
        *self.as_str() == **other
    }
}
impl PartialEq<TargetPointerWidth> for String {
    fn eq(&self, other: &TargetPointerWidth) -> bool {
        **self == *other.as_str()
    }
}
impl PartialEq<TargetPointerWidth> for &String {
    fn eq(&self, other: &TargetPointerWidth) -> bool {
        ***self == *other.as_str()
    }
}
impl PartialEq<Box<str>> for TargetPointerWidth {
    fn eq(&self, other: &Box<str>) -> bool {
        *self.as_str() == **other
    }
}
impl PartialEq<&Box<str>> for TargetPointerWidth {
    fn eq(&self, &other: &&Box<str>) -> bool {
        *self.as_str() == **other
    }
}
impl PartialEq<TargetPointerWidth> for Box<str> {
    fn eq(&self, other: &TargetPointerWidth) -> bool {
        **self == *other.as_str()
    }
}
impl PartialEq<TargetPointerWidth> for &Box<str> {
    fn eq(&self, other: &TargetPointerWidth) -> bool {
        ***self == *other.as_str()
    }
}
impl PartialEq<u16> for TargetPointerWidth {
    fn eq(&self, other: &u16) -> bool {
        match &self.0 {
            TargetPointerWidthRepr::_16 => 16 == *other,
            TargetPointerWidthRepr::_32 => 32 == *other,
            TargetPointerWidthRepr::_64 => 64 == *other,
            TargetPointerWidthRepr::__Other(this) => this.parse().ok() == Some(*other),
        }
    }
}
impl PartialEq<u16> for &TargetPointerWidth {
    fn eq(&self, other: &u16) -> bool {
        *self == other
    }
}
impl PartialEq<TargetPointerWidth> for u16 {
    fn eq(&self, other: &TargetPointerWidth) -> bool {
        other == self
    }
}
impl PartialEq<&TargetPointerWidth> for u16 {
    fn eq(&self, &other: &&TargetPointerWidth) -> bool {
        other == self
    }
}
impl PartialEq<i32> for TargetPointerWidth {
    fn eq(&self, other: &i32) -> bool {
        match &self.0 {
            TargetPointerWidthRepr::_16 => 16 == *other,
            TargetPointerWidthRepr::_32 => 32 == *other,
            TargetPointerWidthRepr::_64 => 64 == *other,
            TargetPointerWidthRepr::__Other(this) => this.parse().ok() == Some(*other),
        }
    }
}
impl PartialEq<i32> for &TargetPointerWidth {
    fn eq(&self, other: &i32) -> bool {
        *self == other
    }
}
impl PartialEq<TargetPointerWidth> for i32 {
    fn eq(&self, other: &TargetPointerWidth) -> bool {
        other == self
    }
}
impl PartialEq<&TargetPointerWidth> for i32 {
    fn eq(&self, &other: &&TargetPointerWidth) -> bool {
        other == self
    }
}
impl PartialEq<u32> for TargetPointerWidth {
    fn eq(&self, other: &u32) -> bool {
        match &self.0 {
            TargetPointerWidthRepr::_16 => 16 == *other,
            TargetPointerWidthRepr::_32 => 32 == *other,
            TargetPointerWidthRepr::_64 => 64 == *other,
            TargetPointerWidthRepr::__Other(this) => this.parse().ok() == Some(*other),
        }
    }
}
impl PartialEq<u32> for &TargetPointerWidth {
    fn eq(&self, other: &u32) -> bool {
        *self == other
    }
}
impl PartialEq<TargetPointerWidth> for u32 {
    fn eq(&self, other: &TargetPointerWidth) -> bool {
        other == self
    }
}
impl PartialEq<&TargetPointerWidth> for u32 {
    fn eq(&self, &other: &&TargetPointerWidth) -> bool {
        other == self
    }
}
impl PartialEq<u64> for TargetPointerWidth {
    fn eq(&self, other: &u64) -> bool {
        match &self.0 {
            TargetPointerWidthRepr::_16 => 16 == *other,
            TargetPointerWidthRepr::_32 => 32 == *other,
            TargetPointerWidthRepr::_64 => 64 == *other,
            TargetPointerWidthRepr::__Other(this) => this.parse().ok() == Some(*other),
        }
    }
}
impl PartialEq<u64> for &TargetPointerWidth {
    fn eq(&self, other: &u64) -> bool {
        *self == other
    }
}
impl PartialEq<TargetPointerWidth> for u64 {
    fn eq(&self, other: &TargetPointerWidth) -> bool {
        other == self
    }
}
impl PartialEq<&TargetPointerWidth> for u64 {
    fn eq(&self, &other: &&TargetPointerWidth) -> bool {
        other == self
    }
}
impl FromStr for TargetPointerWidth {
    type Err = crate::Error;
    fn from_str(s: &str) -> Result<Self, Self::Err> {
        match s {
            "16" => Ok(Self(TargetPointerWidthRepr::_16)),
            "32" => Ok(Self(TargetPointerWidthRepr::_32)),
            "64" => Ok(Self(TargetPointerWidthRepr::_64)),
            s => Ok(Self(TargetPointerWidthRepr::__Other(s.into()))),
        }
    }
}
impl Cfg for TargetPointerWidth {
    type Output = Self;
    const KEY: &'static str = "target_pointer_width";
    type Error = crate::Error;
    const MAX: usize = 1;
    fn from_values<I: ExactSizeIterator<Item = V>, V: AsRef<str>>(
        mut values: I,
    ) -> Result<Self::Output, Self::Error> {
        values.next().unwrap().as_ref().parse()
    }
    fn default_output() -> Option<Self::Output> {
        None
    }
}
impl fmt::Debug for TargetPointerWidth {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        fmt::Debug::fmt(self.as_str(), f)
    }
}
impl fmt::Display for TargetPointerWidth {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        f.write_str(self.as_str())
    }
}

/// `cfg(target_vendor == "..")`
/// (Rust 1.33+)
///
/// All non-empty values used in builtin targets in 1.8 (where `rustc --print cfg` was added)
/// to 1.93 are available as variants. To construct other values, use
/// `TargetVendor::from`/`.into()`; to reference them, use `.as_str()` or comparison to `&str`.
#[derive(Clone)]
#[non_exhaustive]
pub enum TargetVendor {
    amd,
    apple,
    espressif,
    fortanix,
    ibm,
    kmc,
    mti,
    nintendo,
    nvidia,
    openwrt,
    pc,
    risc0,
    rumprun,
    sony,
    sun,
    unikraft,
    unknown,
    uwp,
    vex,
    win7,
    wrs,
    #[doc(hidden)]
    #[deprecated(note = "do not use this variant directly; use as_str or compare with a string instead")]
    __Other(Box<str>),
}
impl TargetVendor {
    #[must_use]
    pub const fn as_str(&self) -> &str {
        match self {
            Self::amd => "amd",
            Self::apple => "apple",
            Self::espressif => "espressif",
            Self::fortanix => "fortanix",
            Self::ibm => "ibm",
            Self::kmc => "kmc",
            Self::mti => "mti",
            Self::nintendo => "nintendo",
            Self::nvidia => "nvidia",
            Self::openwrt => "openwrt",
            Self::pc => "pc",
            Self::risc0 => "risc0",
            Self::rumprun => "rumprun",
            Self::sony => "sony",
            Self::sun => "sun",
            Self::unikraft => "unikraft",
            Self::unknown => "unknown",
            Self::uwp => "uwp",
            Self::vex => "vex",
            Self::win7 => "win7",
            Self::wrs => "wrs",
            #[allow(deprecated)]
            Self::__Other(s) => s,
        }
    }
}
impl PartialEq for TargetVendor {
    fn eq(&self, other: &Self) -> bool {
        match (self, other) {
            // Even after new variants are added, to ensure comparisons in old
            // code using __Other still work, compare strings if either is __Other.
            #[allow(deprecated)]
            (Self::__Other(_), _) | (_, Self::__Other(_)) => self.as_str() == other.as_str(),
            (this, other) => mem::discriminant(this) == mem::discriminant(other),
        }
    }
}
impl Eq for TargetVendor {}
impl PartialEq<str> for TargetVendor {
    fn eq(&self, other: &str) -> bool {
        *self.as_str() == *other
    }
}
impl PartialEq<&str> for TargetVendor {
    fn eq(&self, &other: &&str) -> bool {
        *self.as_str() == *other
    }
}
impl PartialEq<TargetVendor> for str {
    fn eq(&self, other: &TargetVendor) -> bool {
        *self == *other.as_str()
    }
}
impl PartialEq<TargetVendor> for &str {
    fn eq(&self, other: &TargetVendor) -> bool {
        **self == *other.as_str()
    }
}
impl PartialEq<String> for TargetVendor {
    fn eq(&self, other: &String) -> bool {
        *self.as_str() == **other
    }
}
impl PartialEq<&String> for TargetVendor {
    fn eq(&self, &other: &&String) -> bool {
        *self.as_str() == **other
    }
}
impl PartialEq<TargetVendor> for String {
    fn eq(&self, other: &TargetVendor) -> bool {
        **self == *other.as_str()
    }
}
impl PartialEq<TargetVendor> for &String {
    fn eq(&self, other: &TargetVendor) -> bool {
        ***self == *other.as_str()
    }
}
impl PartialEq<Box<str>> for TargetVendor {
    fn eq(&self, other: &Box<str>) -> bool {
        *self.as_str() == **other
    }
}
impl PartialEq<&Box<str>> for TargetVendor {
    fn eq(&self, &other: &&Box<str>) -> bool {
        *self.as_str() == **other
    }
}
impl PartialEq<TargetVendor> for Box<str> {
    fn eq(&self, other: &TargetVendor) -> bool {
        **self == *other.as_str()
    }
}
impl PartialEq<TargetVendor> for &Box<str> {
    fn eq(&self, other: &TargetVendor) -> bool {
        ***self == *other.as_str()
    }
}
impl From<&str> for TargetVendor {
    fn from(s: &str) -> Self {
        match Self::from_str(s) {
            Ok(s) => s,
            Err(e) => match e {},
        }
    }
}
impl FromStr for TargetVendor {
    type Err = core::convert::Infallible;
    fn from_str(s: &str) -> Result<Self, Self::Err> {
        match s {
            "amd" => Ok(Self::amd),
            "apple" => Ok(Self::apple),
            "espressif" => Ok(Self::espressif),
            "fortanix" => Ok(Self::fortanix),
            "ibm" => Ok(Self::ibm),
            "kmc" => Ok(Self::kmc),
            "mti" => Ok(Self::mti),
            "nintendo" => Ok(Self::nintendo),
            "nvidia" => Ok(Self::nvidia),
            "openwrt" => Ok(Self::openwrt),
            "pc" => Ok(Self::pc),
            "risc0" => Ok(Self::risc0),
            "rumprun" => Ok(Self::rumprun),
            "sony" => Ok(Self::sony),
            "sun" => Ok(Self::sun),
            "unikraft" => Ok(Self::unikraft),
            "unknown" => Ok(Self::unknown),
            "uwp" => Ok(Self::uwp),
            "vex" => Ok(Self::vex),
            "win7" => Ok(Self::win7),
            "wrs" => Ok(Self::wrs),
            #[allow(deprecated)]
            s => Ok(Self::__Other(s.into())),
        }
    }
}
impl Cfg for TargetVendor {
    type Output = Option<Self>;
    const KEY: &'static str = "target_vendor";
    type Error = core::convert::Infallible;
    const MAX: usize = 1;
    fn from_values<I: ExactSizeIterator<Item = V>, V: AsRef<str>>(
        mut values: I,
    ) -> Result<Self::Output, Self::Error> {
        Ok(Some(values.next().unwrap().as_ref().parse()?))
    }
    fn default_output() -> Option<Self::Output> {
        Some(None)
    }
}
impl fmt::Debug for TargetVendor {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        fmt::Debug::fmt(self.as_str(), f)
    }
}
impl fmt::Display for TargetVendor {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        f.write_str(self.as_str())
    }
}
